#!/bin/sh
#
# Copy some of the libraries required to run the test application (others
# are handled by the Package tab in the CodeWarrior project).
#

##
# Utility function for file/directory copying
##
CopyFile ()  # copyCmd, source, dest
{
	/Developer/Tools/CpMac "$1" "$2"
}

CopyDir ()
{
	if [ -e "$2" ]; then
		/usr/bin/chflags -R nouchg "$2"
		/bin/rm -rf "$2"
	fi
	/Developer/Tools/CpMac -r "$1" "$2"
}

srcStrings="${SRCROOT}/../../source/resources/strings"
thirdParty="${SRCROOT}/../../third_party"
resTarget="${CONFIGURATION_BUILD_DIR}/Bridge CS3.app/Contents/Resources"
LegalTarget="${CONFIGURATION_BUILD_DIR}/Legal"

# Create Resource folder
echo "Create Resource folders"
mkdir -p "${resTarget}/en.lproj"
mkdir -p "${resTarget}/da.lproj"
mkdir -p "${resTarget}/de.lproj"
mkdir -p "${resTarget}/cs.lproj"
mkdir -p "${resTarget}/el.lproj"
mkdir -p "${resTarget}/es.lproj"
mkdir -p "${resTarget}/fi.lproj"
mkdir -p "${resTarget}/fr.lproj"
mkdir -p "${resTarget}/hu.lproj"
mkdir -p "${resTarget}/it.lproj"
mkdir -p "${resTarget}/ja.lproj"
mkdir -p "${resTarget}/ko.lproj"
mkdir -p "${resTarget}/nl.lproj"
mkdir -p "${resTarget}/nb.lproj"
mkdir -p "${resTarget}/pl.lproj"
mkdir -p "${resTarget}/pt.lproj"
mkdir -p "${resTarget}/ru.lproj"
mkdir -p "${resTarget}/sv.lproj"
mkdir -p "${resTarget}/tr.lproj"
mkdir -p "${resTarget}/ro.lproj"
mkdir -p "${resTarget}/uk.lproj"
mkdir -p "${resTarget}/zh_CN.lproj"
mkdir -p "${resTarget}/zh_TW.lproj"

# String files
echo "Copy String Files"
CopyFile "${srcStrings}/cs/strings.txt" "${resTarget}/cs.lproj/"
CopyFile "${srcStrings}/da/strings.txt" "${resTarget}/da.lproj/"
CopyFile "${srcStrings}/de/strings.txt" "${resTarget}/de.lproj/"
CopyFile "${srcStrings}/el/strings.txt" "${resTarget}/el.lproj/"
CopyFile "${srcStrings}/es/strings.txt" "${resTarget}/es.lproj/"
CopyFile "${srcStrings}/fi/strings.txt" "${resTarget}/fi.lproj/"
CopyFile "${srcStrings}/fr/strings.txt" "${resTarget}/fr.lproj/"
CopyFile "${srcStrings}/hu/strings.txt" "${resTarget}/hu.lproj/"
CopyFile "${srcStrings}/it/strings.txt" "${resTarget}/it.lproj/"
CopyFile "${srcStrings}/ja/strings.txt" "${resTarget}/ja.lproj/"
CopyFile "${srcStrings}/ko/strings.txt" "${resTarget}/ko.lproj/"
CopyFile "${srcStrings}/nl/strings.txt" "${resTarget}/nl.lproj/"
CopyFile "${srcStrings}/no/strings.txt" "${resTarget}/nb.lproj/"
CopyFile "${srcStrings}/pl/strings.txt" "${resTarget}/pl.lproj/"
CopyFile "${srcStrings}/pt/strings.txt" "${resTarget}/pt.lproj/"
CopyFile "${srcStrings}/ru/strings.txt" "${resTarget}/ru.lproj/"
CopyFile "${srcStrings}/sv/strings.txt" "${resTarget}/sv.lproj/"
CopyFile "${srcStrings}/tr/strings.txt" "${resTarget}/tr.lproj/"
CopyFile "${srcStrings}/ro/strings.txt" "${resTarget}/ro.lproj/"
CopyFile "${srcStrings}/uk/strings.txt" "${resTarget}/uk.lproj/"
CopyFile "${srcStrings}/zh_CN/strings.txt" "${resTarget}/zh_CN.lproj/"
CopyFile "${srcStrings}/zh_TW/strings.txt" "${resTarget}/zh_TW.lproj/"

# Shortcut files
echo "Copy Shortcut Files"
CopyFile "${srcStrings}/cs/shortcuts.txt" "${resTarget}/cs.lproj/"
CopyFile "${srcStrings}/da/shortcuts.txt" "${resTarget}/da.lproj/"
CopyFile "${srcStrings}/de/shortcuts.txt" "${resTarget}/de.lproj/"
CopyFile "${srcStrings}/el/shortcuts.txt" "${resTarget}/el.lproj/"
CopyFile "${srcStrings}/es/shortcuts.txt" "${resTarget}/es.lproj/"
CopyFile "${srcStrings}/fi/shortcuts.txt" "${resTarget}/fi.lproj/"
CopyFile "${srcStrings}/fr/shortcuts.txt" "${resTarget}/fr.lproj/"
CopyFile "${srcStrings}/hu/shortcuts.txt" "${resTarget}/hu.lproj/"
CopyFile "${srcStrings}/it/shortcuts.txt" "${resTarget}/it.lproj/"
CopyFile "${srcStrings}/ja/shortcuts.txt" "${resTarget}/ja.lproj/"
CopyFile "${srcStrings}/ko/shortcuts.txt" "${resTarget}/ko.lproj/"
CopyFile "${srcStrings}/nl/shortcuts.txt" "${resTarget}/nl.lproj/"
CopyFile "${srcStrings}/no/shortcuts.txt" "${resTarget}/nb.lproj/"
CopyFile "${srcStrings}/pl/shortcuts.txt" "${resTarget}/pl.lproj/"
CopyFile "${srcStrings}/pt/shortcuts.txt" "${resTarget}/pt.lproj/"
CopyFile "${srcStrings}/ru/shortcuts.txt" "${resTarget}/ru.lproj/"
CopyFile "${srcStrings}/sv/shortcuts.txt" "${resTarget}/sv.lproj/"
CopyFile "${srcStrings}/tr/shortcuts.txt" "${resTarget}/tr.lproj/"
CopyFile "${srcStrings}/ro/shortcuts.txt" "${resTarget}/ro.lproj/"
CopyFile "${srcStrings}/uk/shortcuts.txt" "${resTarget}/uk.lproj/"
CopyFile "${srcStrings}/zh_CN/shortcuts.txt" "${resTarget}/zh_CN.lproj/"
CopyFile "${srcStrings}/zh_TW/shortcuts.txt" "${resTarget}/zh_TW.lproj/"

# Extendscript
echo "Copy Extendscript Strings"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-da_DK.dat" "${resTarget}/da.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-de_DE.dat" "${resTarget}/de.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-es_ES.dat" "${resTarget}/es.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-fi_FI.dat" "${resTarget}/fi.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-fr_FR.dat" "${resTarget}/fr.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-it_IT.dat" "${resTarget}/it.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-ja_JP.dat" "${resTarget}/ja.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-ko_KR.dat" "${resTarget}/ko.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-nl_NL.dat" "${resTarget}/nl.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-no_NO.dat" "${resTarget}/nb.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-pt_BR.dat" "${resTarget}/pt.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-sv_SE.dat" "${resTarget}/sv.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-zh_CN.dat" "${resTarget}/zh_CN.lproj/extendscript.dat"
CopyFile "${thirdParty}/extendscript/extendscript/public/zstrings/extendscript-zh_TW.dat" "${resTarget}/zh_TW.lproj/extendscript.dat"

# File Info
echo "Copy File Info strings"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_cs_CZ.dat" "${resTarget}/cs.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_da_DK.dat" "${resTarget}/da.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_de_DE.dat" "${resTarget}/de.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_el_GR.dat" "${resTarget}/el.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_es_ES.dat" "${resTarget}/es.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_fi_FI.dat" "${resTarget}/fi.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_fr_FR.dat" "${resTarget}/fr.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_hu_HU.dat" "${resTarget}/hu.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_it_IT.dat" "${resTarget}/it.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_ja_JP.dat" "${resTarget}/ja.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_ko_KR.dat" "${resTarget}/ko.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_nl_NL.dat" "${resTarget}/nl.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_no_NO.dat" "${resTarget}/nb.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_pl_PL.dat" "${resTarget}/pl.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_pt_BR.dat" "${resTarget}/pt.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_ru_RU.dat" "${resTarget}/ru.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_sv_SE.dat" "${resTarget}/sv.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_tr_TR.dat" "${resTarget}/tr.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_ro_RO.dat" "${resTarget}/ro.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_uk_UA.dat" "${resTarget}/uk.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_zh_CN.dat" "${resTarget}/zh_CN.lproj/FileInfo.dat"
CopyFile "${thirdParty}/fileinfo/dictionaries/FileInfo_zh_TW.dat" "${resTarget}/zh_TW.lproj/FileInfo.dat"

# OLS
echo "Copy OLS files"
CopyFile "${thirdParty}/ols/localizations/de.lproj/ols.dat" "${resTarget}/de.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/es.lproj/ols.dat" "${resTarget}/es.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/fr.lproj/ols.dat" "${resTarget}/fr.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/it.lproj/ols.dat" "${resTarget}/it.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/ja.lproj/ols.dat" "${resTarget}/ja.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/nl.lproj/ols.dat" "${resTarget}/nl.lproj/ols.dat"
CopyFile "${thirdParty}/ols/localizations/sv.lproj/ols.dat" "${resTarget}/sv.lproj/ols.dat"

#Opera
echo "Copy Opera strings"
CopyFile "${thirdParty}/opera/opera/lng/da_DK.lng" "${resTarget}/da.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/de_DE.lng" "${resTarget}/de.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/es_ES.lng" "${resTarget}/es.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/fi_FI.lng" "${resTarget}/fi.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/fr_FR.lng" "${resTarget}/fr.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/it_IT.lng" "${resTarget}/it.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/ja_JP.lng" "${resTarget}/ja.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/ko_KR.lng" "${resTarget}/ko.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/nl_NL.lng" "${resTarget}/nl.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/pt_BR.lng" "${resTarget}/pt.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/sv_SE.lng" "${resTarget}/sv.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/zh_CN.lng" "${resTarget}/zh_CN.lproj/opera.lng"
CopyFile "${thirdParty}/opera/opera/lng/zh_TW.lng" "${resTarget}/zh_TW.lproj/opera.lng"

# Adobe Bridge Opener Preferences
echo "Copy Bridge Opener Preferences"
CopyFile "${thirdParty}/preferences/Adobe Bridge Opener Preferences.xml" "${resTarget}/en.lproj/"
CopyFile "${thirdParty}/preferences/cs_CZ/Adobe Bridge Opener Preferences.xml" "${resTarget}/cs.lproj/"
CopyFile "${thirdParty}/preferences/da_DK/Adobe Bridge Opener Preferences.xml" "${resTarget}/da.lproj/"
CopyFile "${thirdParty}/preferences/de_DE/Adobe Bridge Opener Preferences.xml" "${resTarget}/de.lproj/"
CopyFile "${thirdParty}/preferences/el_GR/Adobe Bridge Opener Preferences.xml" "${resTarget}/el.lproj/"
CopyFile "${thirdParty}/preferences/es_ES/Adobe Bridge Opener Preferences.xml" "${resTarget}/es.lproj/"
CopyFile "${thirdParty}/preferences/fi_FI/Adobe Bridge Opener Preferences.xml" "${resTarget}/fi.lproj/"
CopyFile "${thirdParty}/preferences/fr_FR/Adobe Bridge Opener Preferences.xml" "${resTarget}/fr.lproj/"
CopyFile "${thirdParty}/preferences/hu_HU/Adobe Bridge Opener Preferences.xml" "${resTarget}/hu.lproj/"
CopyFile "${thirdParty}/preferences/it_IT/Adobe Bridge Opener Preferences.xml" "${resTarget}/it.lproj/"
CopyFile "${thirdParty}/preferences/ja_JP/Adobe Bridge Opener Preferences.xml" "${resTarget}/ja.lproj/"
CopyFile "${thirdParty}/preferences/ko_KR/Adobe Bridge Opener Preferences.xml" "${resTarget}/ko.lproj/"
CopyFile "${thirdParty}/preferences/nl_NL/Adobe Bridge Opener Preferences.xml" "${resTarget}/nl.lproj/"
CopyFile "${thirdParty}/preferences/no_NO/Adobe Bridge Opener Preferences.xml" "${resTarget}/nb.lproj/"
CopyFile "${thirdParty}/preferences/pl_PL/Adobe Bridge Opener Preferences.xml" "${resTarget}/pl.lproj/"
CopyFile "${thirdParty}/preferences/pt_BR/Adobe Bridge Opener Preferences.xml" "${resTarget}/pt.lproj/"
CopyFile "${thirdParty}/preferences/ru_RU/Adobe Bridge Opener Preferences.xml" "${resTarget}/ru.lproj/"
CopyFile "${thirdParty}/preferences/sv_SE/Adobe Bridge Opener Preferences.xml" "${resTarget}/sv.lproj/"
CopyFile "${thirdParty}/preferences/tr_TR/Adobe Bridge Opener Preferences.xml" "${resTarget}/tr.lproj/"
CopyFile "${thirdParty}/preferences/ro_RO/Adobe Bridge Opener Preferences.xml" "${resTarget}/ro.lproj/"
CopyFile "${thirdParty}/preferences/uk_UA/Adobe Bridge Opener Preferences.xml" "${resTarget}/uk.lproj/"
CopyFile "${thirdParty}/preferences/zh_CN/Adobe Bridge Opener Preferences.xml" "${resTarget}/zh_CN.lproj/"
CopyFile "${thirdParty}/preferences/zh_TW/Adobe Bridge Opener Preferences.xml" "${resTarget}/zh_TW.lproj/"
